<?php
/**
 * Parses and generates email parameters
 *
 * Reads information from an email and maps sender address to a pid
 *
 * PHP versions 4 and 5
 *
 * LICENSE: This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA  02111-1307  USA 
 *
 * @category    WebBuilder
 * @package     WebBuilder_Param
 * @author      Christopher Linn <linn@backendmedia.com>
 * @author      Lukas Smith <smith@backendmedia.com>
 * @copyright   2003-2006 BackendMedia Linn Zwoch Smith GbR
 * @license     http://www.gnu.org/licenses/lgpl.txt
 * @link        http://svn.oss.backendmedia.com/library/Param/Email.phps
 */

class Param_Email
{
	// {{{ generate()
	/**
	 * generate mod_rewrite style string of $param
	 *
	* @param array $param is an array thats to be represented in a link
	 * @return string containing the link
	 * @access public
	 */
	function generate($param)
	{
		$link = '';
		return $link;
	}

	// {{{ parse()
	/**
	 * parse a call string into an array
	 *
	 * @return array containing the parsed parameters
	 * @access public
	 */
	function parse($params_raw = null)
	{
		$param = array();

		// read from stdin
		$fd = fopen("php://stdin", "r");
		$email = "";
		while (!feof($fd)) {
			$email .= fread($fd, 1024);
		}
		fclose($fd);

		// handle email
		$lines = explode("\n", $email);

		// empty vars
		$param['from'] = "";
		$param['subject'] = "";
		$param['headers'] = "";
		$param['message'] = "";
		$param['to'] = "";
		$param['email'] = $email;
		$splittingheaders = true;

		for ($i=0; $i<count($lines); $i++) {
			if ($splittingheaders) {
				// this is a header
				$param['headers'] .= $lines[$i].'\n';

				// look out for special headers
				if (preg_match('/^Subject: (.*)/', $lines[$i], $matches)) {
					$param['subject'] = $matches[1];
				}
				if (preg_match('/^From: (.*)/', $lines[$i], $matches)) {
					$param['from'] = $matches[1];
				}
				if (preg_match('/^To: (.*)/', $lines[$i], $matches)) {
					$param['to'] = $matches[1];
				}
			} else {
				// not a header, but message
				$param['message'] .= $lines[$i].'\n';
			}

			if (trim($lines[$i])=='') {
				// empty line, header section has ended
				$splittingheaders = false;
			}
		}

		$query = 'INSERT into email_save';
		$query.= ' VALUES ('.$GLOBALS['system']['mdb']->quote(null,'integer');
		$query.= ','.$GLOBALS['system']['mdb']->quote($param['headers'],'text');
		$query.= ','.$GLOBALS['system']['mdb']->quote($param['subject'],'text');
		$query.= ','.$GLOBALS['system']['mdb']->quote($param['from'],'text');
		$query.= ','.$GLOBALS['system']['mdb']->quote($param['to'],'text');
		$query.= ','.$GLOBALS['system']['mdb']->quote($param['message'],'text');
		$query.= ','.$GLOBALS['system']['mdb']->quote(MDB2_Date::mdbNow(),'timestamp');
		$query.= ')';
		$GLOBALS['system']['mdb']->exec($query);

		$query = 'SELECT pid FROM email_page_rel';
		$query.= ' WHERE email_to='.$GLOBALS['system']['mdb']->quote($param['to'],'text');
		$pid = $GLOBALS['system']['mdb']->queryOne($query);

		if ($pid) {
			$param['system']['pid'] = $pid;
			$param['pid'] = $pid;
		}

		return $param;
	}
	// }}}
}

?>