<?php
/**
 * Factory for he various param reader classes
 *
 * Factory for parsing parameters using the requested param reader class
 *
 * PHP versions 4 and 5
 *
 * LICENSE: This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA  02111-1307  USA 
 *
 * @category    WebBuilder
 * @package     WebBuilder_Param
 * @author      Lukas Smith <smith@backendmedia.com>
 * @copyright   2003-2006 BackendMedia Linn Zwoch Smith GbR
 * @license     http://www.gnu.org/licenses/lgpl.txt
 * @link        http://svn.oss.backendmedia.com/library/Param/Reader.phps
 */

	// does not yet exist
	if(!function_exists('array_merge_replace')) {
		function array_merge_replace($a1, $a2)
		{
			if (!is_array($a1) || !is_array($a2)) {
				return false;
			}
			foreach($a2 as $key => $val) {
				if (is_array($val)
					&& isset($a1[$key])
					&& is_array($a1[$key])
				) {
					$a1[$key] = array_merge_replace($a1[$key], $val);
				} else {
					$a1[$key] = $val;
				}
			}
			return $a1;
		}
	}

class Param_Reader
{
	// }}}
	// {{{ parse()

	/**
	 * factory which calls a given reader
	 * 
	 * @param string $reader_type determines the type of reader to use
	 * @return array containing the parameters
	 * @access public
	 */
	function parse($reader_type)
	{
		switch ($reader_type) {
		case 'shell':
			require_once('Param/Shell.php');
			$param = Param_Shell::parse();
			break;
		case 'email':
			require_once('Param/Email.php');
			$param = Param_Email::parse();
			break;
		default:
			// www
			require_once('Param/WWW.php');
			$param = Param_WWW::parse();
			break;
		}
		return $param;
	}
}
?>