<?php
/**
 * Parses and generates shell parameters
 *
 * Parses and generates shell parameters in a nicely readable format.
 *
 * PHP versions 4 and 5
 *
 * LICENSE: This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA  02111-1307  USA 
 *
 * @category    WebBuilder
 * @package     WebBuilder_Param
 * @author      Christopher Linn <linn@backendmedia.com>
 * @author      Lukas Smith <smith@backendmedia.com>
 * @copyright   2003-2006 BackendMedia Linn Zwoch Smith GbR
 * @license     http://www.gnu.org/licenses/lgpl.txt
 * @link        http://svn.oss.backendmedia.com/library/Param/Shell.phps
 */

/*
$shell_parameters["system"]["pid"] = "ip_scheduler_mail";
$shell_parameters["MAIN"]["data"] = "usage";
$shell_parameters["MAIN"]["action"] = "execute";

$query = 'shell.php'.Param_shell::generate($shell_parameters);
echo $query."\n";
*/

class Param_Shell
{
	// {{{ generate()
	/**
	 * generate mod_rewrite style string of $param
	 *
	* @param array $param is an array thats to be represented in a link
	 * @return string containing the link
	 * @access public
	 */
	function generate($param)
	{
		$link = '';
		foreach ($param as $key => $value) {
			$link .= ' "'.Param_shell::shell_encode_key($key).'"';
			$link .= ' "'.Param_shell::shell_encode_value($value).'"';
		}
		return $link;
	}

	function shell_encode_value($value)
	{
		return addslashes(serialize($value));
	}

	function shell_encode_key($key)
	{
		return $key;
	}

	// {{{ parse()
	/**
	 * parse a call string into an array
	 *
	 * @return array containing the parsed parameters
	 * @access public
	 */
	function parse()
	{
		$param = array();
		for ($i=1;$i<$_SERVER['argc'];++$i) {
			$key = Param_shell::shell_decode_key($_SERVER['argv'][$i]);
			$value = Param_shell::shell_decode_value($_SERVER['argv'][++$i]);
			$param[$key] = $value;
		}
		return $param;
	}
	// }}}

	function shell_decode_value($value)
	{
		return unserialize(stripslashes($value));
	}

	function shell_decode_key($key)
	{
		return $key;
	}
}

?>