<?php
/**
 * Parses and generates URL's
 *
 * Parses and generates URL's. Also supports mod_rewrite.
 *
 * PHP versions 4 and 5
 *
 * LICENSE: This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA  02111-1307  USA 
 *
 * @category    WebBuilder
 * @package     WebBuilder_Param
 * @author      Ralf Willenbacher <ralf@backendmedia.com>
 * @author      Lukas Smith <smith@backendmedia.com>
 * @copyright   2003-2006 BackendMedia Linn Zwoch Smith GbR
 * @license     http://www.gnu.org/licenses/lgpl.txt
 * @link        http://svn.oss.backendmedia.com/library/Param/WWW.phps
 */

/*
include 'BC_lib.php';
$GLOBALS['system']['mod_rewrite'] = true;
$array = array('system' => array('pid' => 'guestbook'), 'MAIN' => array('mode' => 'edit_message', 'message_id' => 23, 'message' => array('action' => array('delete'))));
var_dump($array);
echo $str = Param_WWW::generate($array);
var_dump(Param_WWW::parse($str));
*/

class Param_WWW
{
	// {{{ generateCookie()
	/** stores the array values in cookie identified by name
	 *  @param array $values
	 *  @name
	 */
	function generateCookie($values, $name)
	{
		setcookie($name, base64_encode(serialize($values)), 0, '/');
	}
	// }}}

	// {{{ getCookie()
	/** gets the array stored in cookie name
	 *  @name
	 *  @return array
	 */
	function getCookie($name)
	{
		$c = $_COOKIE[$name];
		if (!isset($c)) {
			return false;
		}
		return unserialize(base64_decode($c));
	}
	// }}}

	// {{{ generate()
	/**
	 * generate mod_rewrite style string of $param
	 *
	* @param array $param is an array thats to be represented in a link
	 * @return string containing the link
	 * @access public
	 */
	function generate($param = null, $fixed = array(), $force_transaction_id = false)
	{
		static $link_tmp;
		if (!isset($link_tmp)) {
			$link_tmp = preg_replace('/^(.*)[\/].+/', '\1', $_SERVER['SCRIPT_NAME']);
		}

		$link = $link_tmp;
		$mod_rewrite = $GLOBALS['core']['mod_rewrite'];

		if (isset($GLOBALS['system']['session']) && $GLOBALS['system']['session']) {
			$sid_name = ini_get('session.name');

			if ($GLOBALS['core']['cookies_enabled'] === 'force' || isset($_COOKIE[$sid_name])) {
				if (isset($param[$sid_name])) {
					unset($param[$sid_name]);
				}
			} elseif (!isset($param[$sid_name])
				&& ($GLOBALS['system']['session'] === true
					|| ($GLOBALS['system']['session'] === 'onlogin' && $GLOBALS['system']['liveuser']->isLoggedIn())
				)
			) {
				$param[$sid_name] = session_id();
			}
		}

		if (!isset($param['system']['transaction_id'])
			&& isset($GLOBALS['system']['transaction'])&& $GLOBALS['system']['transaction']
			&& ($force_transaction_id || $GLOBALS['system']['transaction'] === 'force')
		) {
			$transaction_id = md5(uniqid(rand()));
			$_SESSION['transactions'][$transaction_id] = true;
			$param['system']['transaction_id'] = $transaction_id;
		}

		if (!empty($param) && is_array($param)) {
			if ($mod_rewrite) {
				$values_without_key = false;
				if (is_array($mod_rewrite) && !empty($mod_rewrite)) {
					// write the parameters that are indentified by their position
					foreach ($mod_rewrite as $index) {
						if (isset($param['system'][$index])) {
							$link .= Param_WWW::asRewrite($param['system'][$index]);
							unset($param['system'][$index]);
						} else {
							$link .= Param_WWW::asRewrite(null);
						}
					}
					$values_without_key = true;
				}
				if (is_array($fixed) && !empty($fixed)) {
					// write the parameters that are indentified by their position
					foreach ($fixed as $value) {
						$link .= Param_WWW::asRewrite($value);
					}
					$values_without_key = true;
				}
				if ($values_without_key) {
					$link .= '/__';
				}
				// ensure that system is at the front
				if (isset($param['system'])) {
					if (!is_array($param['system']) || empty($param['system'])) {
						unset($param['system']);
					} else {
						reset($param);
						if (key($param) !== 'system') {
							$system = $param['system'];
							unset($param['system']);
							$param = array('system' => $system) + $param;
						}
					}
				}
				$rewrite = Param_WWW::asRewrite($param);
				if (isset($param['system'])) {
					// remove '/_system_' from the beginning
					$link .= substr_replace($rewrite, '', 0, 9);
				} else {
					$link .= '/__'.$rewrite;
				}
				/* dump rest */
				$link = preg_replace('/(\/__)+$/', '', $link);
				$link = preg_replace('/\/+$/', '', $link);
			} else {
				$link .= '/'.Param_WWW::asGet($param);
			}
		}

		if ($link === $link_tmp) {
			$link .= '/';
		}

		return $link;
	}
	// }}}

	// {{{ _paramsRecursiveGet()
	/*
	 *
	 *
	 * @param string $prefix
	 * @param array $param
	 * @return string containing the link
	 * @access privat
	 */
	function _paramsRecursiveGet($prefix, $param)
	{
		$link = '';
		$seperator = '&';
		foreach ($param as $index => $value) {
			if (is_array($value)) {
				$subprefix = $prefix."[$index]";
				$link .= Param_WWW::_paramsRecursiveGet($subprefix, $value);
			} else {
				$link .= $prefix."[$index]=$value".$seperator;
			}
		}
		return $link;
	}
	// }}}

	// {{{ asGet()
	/*
	 *
	 * generate GET style string of $param
	 *
	 * @param array $param
	 * @return string containing the link
	 * @access privat
	 */
	function asGet($param)
	{
		$link = '?';
		$seperator = '&';
		foreach ($param as $index => $value) {
			if (is_array($value)) {
				$link .= Param_WWW::_paramsRecursiveGet($index, $value);
			} else {
				$link .= $index.'='.$value.$seperator;
			}
		}
		return $link;
	}
	// }}}

	// {{{ _paramsRecursiveGet()
	/**
	 *
	 *
	 * @param array $param
	 * @return string containing the link
	 * @access privat
	 */
	function _paramsRecursiveRewrite($param)
	{
		$link = '';
		foreach ($param as $index => $value) {
			if (is_array($value)) {
				$link .= '/_'.$index.'_';
				$link .= Param_WWW::_paramsRecursiveRewrite($value);
				$link .= '/__';
			} else {
				$link .= '/'.$index.'/'.urlencode($value);
			}
		}
		return $link;
	}
	// }}}

	// {{{ asRewrite()
	/**
	 * generate mod_rewrite style string of $param
	 *
	 * @param mixed $param string or array
	 * @return string containing the link
	 * @access privat
	 */
	function asRewrite($param)
	{
		if (!is_array($param)) {
			return '/'.urlencode($param);
		}
		$link = '';
		foreach ($param as $index => $value) {
			$link .= '/';
			if (is_array($value)) {
				$link .= '_'.$index.'_';
				$link .= Param_WWW::_paramsRecursiveRewrite($value);
				$link .= '/__';
			} else {
				$link .= $index.'/'.urlencode($value);
			}
		}
		return $link;
	}
	// }}}

	// {{{ parse()
	/**
	 * parse a call string into an array
	 *
	 * @return array containing the parsed parameters
	 * @access public
	 */
	function parse($params_raw = null)
	{
		$param = array();
		$mod_rewrite = $GLOBALS['core']['mod_rewrite'];

		if (is_null($params_raw)) {
			$url_root = '';
			// PHP is not a CGI but instead an apache module?
			if (strpos($_SERVER['SCRIPT_NAME'], 'index.php') !== false) {
				$url_root = preg_replace('/^(.*)[\/].+/', '\1', $_SERVER['SCRIPT_NAME']);
			}
			$params_raw = substr(strip_tags($_SERVER['REQUEST_URI']), strlen($url_root)+1);
			if ($_SERVER['QUERY_STRING']) {
				$params_raw = substr($params_raw, 0, -1*(1+strlen($_SERVER['QUERY_STRING'])));
			}
		}
		if ($mod_rewrite) {
			$mapped_params = array('system' => array(), 'fixed' => array());
			if (is_array($mod_rewrite)) {
				$params_raw_split = explode('__/', $params_raw, 2);
				$params_raw = null;
				if (isset($params_raw_split[0])) {
					$mapped_raw = $params_raw_split[0];
					if (isset($params_raw_split[1])) {
						$params_raw = $params_raw_split[1];
					}
					// remove '/' at start and end
					$mapped_raw = preg_replace('/^(.*[^\/])\/?$/', '\\1', $mapped_raw);
					if ($mapped_raw) {
						$values = explode('/', $mapped_raw);
						// map system params
						foreach ($values as $key => $value) {
							if (isset($mod_rewrite[$key])) {
								$mapped_params['system'][$mod_rewrite[$key]] = urldecode($value);
							} else {
								$mapped_params['fixed'][] = urldecode($value);
							}
						}
					}
				}
			}
			// remove '/' at start and end
			$params_raw = preg_replace('/^(.*[^\/])\/?$/', '\\1', $params_raw);
			if ($params_raw) {
				// add implicit system array opening
				if (substr($params_raw, 0, strlen('__/')) == '__/') {
					$params_raw = substr($params_raw, 3);
				} elseif (substr($params_raw, 0, strlen('_system_/')) != '_system_/') {
					$params_raw = '_system_/'.$params_raw;
				}
				$tokens = explode('/', $params_raw);
				$current_token = 0;
				$param = Param_WWW::getRewrite($tokens, $current_token);
			}

			if (is_array($param)) {
				$param = array_merge_replace($param, $mapped_params);
			} else {
				$param = $mapped_params;
			}
		}
		return array_merge_replace($param, $_REQUEST);
	}
	// }}}

	// {{{ getToken()
	/**
	 * fetches next not null token, advances pointer
	 * @param array $tokens
	 * @param int &$current_token
	 * @return mixed token or false
	 * @access privat
	 */
	function getToken($tokens, &$current_token)
	{
		$len = count($tokens);

		while ($current_token < $len) {
#			if ($tokens[$current_token] != false) {
				return $tokens[$current_token];
#			}
			$current_token++;
		}
		return false;
	}
	// }}}

	// {{{ peekToken()
	/**
	 * next token, doesnt advance pointer
	 *
	 * @param array $tokens
	 * @param int $current_token
	 * @return next token
	 * @access privat
	 */
	function peekToken($tokens, $current_token)
	{
		$ctoken = $current_token;
		Param_WWW::getToken($tokens, $ctoken);
		$ctoken++;
		$peeked = Param_WWW::getToken($tokens, $ctoken);
		return $peeked;
	}
	// }}}

	// {{{ getRewrite()
	/**
	 * @param array $tokens
	 * @param int $current_token
	 * @return array or single value of rewrite style string
	 * @access privat
	 */
	function getRewrite($tokens, &$current_token)
	{
		if (Param_WWW::peekToken($tokens, $current_token) == '__') {
			$result = Param_WWW::getToken($tokens, $current_token);
			$current_token++;
			$underscore_underscore = Param_WWW::getToken($tokens, $current_token);
			$current_token++;
			return $result;
		}

		$thisarray = array();
		while (Param_WWW::getToken($tokens, $current_token) !== false && $tokens[$current_token] !== false) {
			if (preg_match('/^_(.+)_$/',$tokens[$current_token], $index)) {
				$current_token++;
				$thisarray[$index[1]] = Param_WWW::getRewrite($tokens, $current_token);
			} elseif ($tokens[$current_token] == '__') {
				$current_token++;
				return $thisarray;
			} else {
				$index = Param_WWW::getToken($tokens, $current_token);
				$current_token++;
				$thisarray[$index] = urldecode(Param_WWW::getToken($tokens, $current_token));
				$current_token++;
			}
		}
		return $thisarray;
	}
	// }}}
}

?>